#!/bin/sh
cd "$(dirname "$0")" || exit 1
fastboot=bin/linux/fastboot
[ ! -f $fastboot ] && echo "$fastboot not found." && exit 1
[ ! -x $fastboot ] && ! chmod +x $fastboot && echo "$fastboot cannot be executed." && exit 1
echo "Waiting for device..."
device=$($fastboot getvar product 2>&1 | grep -F "product:" | tr -s " " | cut -d " " -f 2)
[ -z "$device" ] && device="unknown"
[ "$device" != "amethyst" ] && echo "Compatible devices: amethyst" && echo "Your device: $device" && exit 1

echo "##################################################################"
echo "Please wait. The device will reboot when installation is finished."
echo "##################################################################"
$fastboot set_active a
$fastboot flash modem_ab modem.img
$fastboot reboot
